-- Democracy.lua
-- Author: Machiavelli
-- DateCreated: 5/6/2013 11:13:24 PM
--------------------------------------------------------------
function GiveHappinessPerSocialPolicy(playerID)
	local player = Players[playerID];
	local city = player:GetCapitalCity();
	local democracyID = GameInfoTypes["POLICY_DEMOCRACY"];

	-- If the player has the policy democracy, count all their social policies and give them that much happiness
	if(player:HasPolicy(democracyID) and not player:IsPolicyBlocked(democracyID)) then
		local int numPolicies = 0;
		for row in GameInfo.Policies() do
			if(player:HasPolicy(row.ID)) then   --and not player:IsPolicyBlocked(row.ID)
				numPolicies = numPolicies + 1;
			end
		end
		
		city:SetNumRealBuilding(GameInfoTypes["BUILDING_HAPPINESS_PER_SOCIAL_POLICY"], numPolicies);
	else
		city:SetNumRealBuilding(GameInfoTypes["BUILDING_HAPPINESS_PER_SOCIAL_POLICY"], 0);
	end
end
GameEvents.PlayerAdoptPolicy.Add(GiveHappinessPerSocialPolicy);
GameEvents.PlayerAdoptPolicyBranch.Add(GiveHappinessPerSocialPolicy);

function HappinessPerSocialPolicyCapitalMove(oldPlayerID, bCapital, iX, iY, newPlayerID, conquest, conquest2)
	local oldPlayer = Players[oldPlayerID];
	local newPlayer = Players[newPlayerID];
	local city =  Map.GetPlot(iX, iY):GetPlotCity();
	local democracyID = GameInfoTypes["POLICY_DEMOCRACY"];

	-- If the old player just lost their capital, they may need to have their democracy buildings replaced
	if(bCapital and oldPlayer:IsAlive() and not oldPlayer:IsMinorCiv() and not oldPlayer:IsBarbarian() and oldPlayer:HasPolicy(democracyID) and not oldPlayer:IsPolicyBlocked(democracyID)) then
		GiveHappinessPerSocialPolicy(oldPlayerID);
	end

	-- If the new player just recovered their capital, they will need to have their capital-only policy buildings moved
	if(newPlayer:GetCapitalCity():GetID() == city:GetID()) then
		-- Remove capital only buildings from the new player's cities
		for cityToRemove in newPlayer:Cities() do
			cityToRemove:SetNumRealBuilding(GameInfoTypes["BUILDING_HAPPINESS_PER_SOCIAL_POLICY"], 0);
		end
		-- Add back the capital-only policy buildings
		GiveHappinessPerSocialPolicy(newPlayerID);
	end
end
GameEvents.CityCaptureComplete.Add(HappinessPerSocialPolicyCapitalMove);

function DisableBlockedDemocracy(playerID)
	local player = Players[playerID];
	local democracyID = GameInfoTypes["POLICY_DEMOCRACY"];

	if(player:HasPolicy(democracyID) and player:IsPolicyBlocked(democracyID)) then
		local city = player:GetCapitalCity();
		city:SetNumRealBuilding(GameInfoTypes["BUILDING_HAPPINESS_PER_SOCIAL_POLICY"], 0);
	end
end
GameEvents.PlayerDoTurn.Add(DisableBlockedDemocracy);